<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage libraries
* @filesource
*//** */
 

/**
* @package direct-as-a-service
* @subpackage libraries
*/
class Permissions {
	private $CI;
	private $access_level;
	public function __construct() {
		$this->CI =& get_instance();
		$this->CI->load->model('usersmodel');
		$this->CI->load->model('applicationmodel');
	}
	
	/*
	 * This function will return an array of uids who are DaaS administrators
	 */
	public function get_daas_admins(){
		$admins = $this->CI->usersmodel->get_daas_admins();
		return $admins;
	}
	
	/*
	 * This function returns comma separated string of application IDs that the user has access to
	 */
	/* public function get_application_admin_permission($id){
		$permissions = $this->CI->usersmodel->get_user_permissions_from_org_id($id);
		
		$app_list = $permissions['Application'];
		$apps = $this->permission_array_filter($app_list, 'search_arr', 'users');
		$keys = array_keys($apps);		

		return $keys;
	} */
	
	/*
	 * This function returns comma separated string of application IDs that the user has user permission to
	 * $access_level is either 'admins' or 'users'
	 */
	public function get_application_permission($id_or_permissions, $access_level){
		if(is_array($id_or_permissions)){
			$permissions = $id_or_permissions;
		}
		else{
			$permissions = $this->CI->usersmodel->get_user_permissions_from_org_id($id_or_permissions);
		}
		$app_list = $permissions['Application'];
		$apps = $this->permission_array_filter($app_list, 'search_arr', $access_level);
		$keys = array_keys($apps);
	
		return $keys;
	}
	
	/* This function uses organizational id (for DOD this is EDIPI) to pull the user permissions,
	 * which return as an associative array split between 'API' and 'Application' permissions.
	 */
	public function get_user_permissions($id) {
		if(!empty($id) && !is_numeric($id)) return $this->error->should_be_an_org_id($id);
		
		//use this line for local development and debugging only
		//$permissions = array('API' => array('admins'=>TRUE), 'Registered' => true);
		
		//use this line for actual development
		$permissions = $this->CI->usersmodel->get_user_permissions_from_org_id($id);
		return $permissions;
	}
	
	/* This function uses the permissions returned from get_user_permissions to set an associative array
	 * of the tabs that the user should be able to see for use in loading views.
	 */
	public function set_tab_access_from_permissions($permissions) {
		//least amount of permissions
		$show = array('onboarding'=>true,'applications'=>false,'reports'=>false,'administration'=>false,'user_settings'=>false,'global_search'=>false);
		//if registered allow applications tab
		if(isset($permissions['Registered']) && $permissions['Registered']) {
			$show = array('onboarding'=>true,'applications'=>true,'facilities'=>false,'reports'=>false,'administration'=>false,'user_settings'=>true,'global_search'=>false);
			//TO-DO: for FOC, if application admin, allow administration tab
			if(isset($permissions['Application'])) {
				foreach($permissions['Application'] as $key => $value) {
					$application = $this->CI->applicationmodel->get_application($key);
					if($application->num_rows() === 1 && isset($value[LDAP_APPLICATION_ADMIN_GROUP_NAME]) && $value[LDAP_APPLICATION_ADMIN_GROUP_NAME]) {
						$show = array('onboarding'=>true,'applications'=>true,'facilities'=>false,'reports'=>false,'administration'=>false,'user_settings'=>true,'global_search'=>false);
					}
				}
			}
			//api admins get all tabs
			if(isset($permissions['API']) && $permissions['API']['admins']) {
				return array('onboarding'=>true,'applications'=>true,'facilities'=>true,'reports'=>true,'administration'=>true,'user_settings'=>true,'global_search'=>true);
			}
			if(isset($permissions['Permission'])){
				foreach($permissions['Permission'] as $key){
					$show[$key] = 1;
				}
			}
		}
		return $show;
	}
	
	/* This function uses the permissions returned from get_user_permissions to set an associative array
	 * of the admin views that the user should be able to see.
	 */
	public function set_admin_access_from_permissions($permissions) {
		//least amount of permissions
		$show = array('application_requests'=>false,'account_requests'=>false,'manage_accounts'=>false);
		//if application admin, allow manage users
		//TO-DO: For FOC, allow app admins to manage users for their app only
		if(isset($permissions['Application'])) {
			foreach($permissions['Application'] as $key => $value) {
				$application = $this->CI->applicationmodel->get_application($key);
				if($application->num_rows() === 1 && isset($value[LDAP_APPLICATION_ADMIN_GROUP_NAME]) && $value[LDAP_APPLICATION_ADMIN_GROUP_NAME]) {
					$show = array('application_requests'=>false,'account_requests'=>false,'manage_accounts'=>false,'manage_groups'=>false, 'manage_facilities'=>true);
				}
			}
		}
		//api admins get all functions
		if(isset($permissions['API']) && $permissions['API']['admins']) {
			$show = array('application_requests'=>true,'account_requests'=>true,'manage_accounts'=>true,'manage_groups'=>true, 'manage_facilities'=>true);
		}
		else{
			$show = array('application_requests'=>in_array('application_requests', $permissions['Permission']),'account_requests'=>in_array('account_requests', $permissions['Permission']),'manage_accounts'=>in_array('manage_accounts', $permissions['Permission']),'manage_groups'=>in_array('manage_groups', $permissions['Permission']));
		}
		return $show;
	}
	
	/* This function returns the authorized API controllers for a given application (given by application id)
	 * by looking up the permissions in LDAP and returning an associative array of permissions.
	 */
	public function get_api_authorization($app_id) {
		$this->CI->load->model('applicationmodel');
		$return_arr['direct'] = $this->CI->applicationmodel->get_direct_api_authorization($app_id);
		$return_arr['admin'] = $this->CI->applicationmodel->get_admin_api_authorization($app_id);
		return $return_arr;
	}
	
	/* This function gets the permissions a user has given a specific application
	 * and returns them as an associative array. Currently the only permission is send
	 * and that permissions is automatically given if the user is linked to the app, but
	 * this function could be expanded in the future to allow for expanded control of permissions.
	 * 
	 * expanded control implemented on 1/31/2014
	 */
	public function get_user_permissions_for_app($user_id,$app_id) {
		$this->CI->load->model('usersmodel');
		$this->CI->load->model('usersettingsmodel');
		$user_name = $this->CI->usersmodel->get_username_from_id($user_id);
		$mailbox_id = $this->CI->usersettingsmodel->get_mailbox_id_by_name($user_name, false);
		//set least possible permissions as default
		$permissions = array();
		$web_services = $this->CI->usersettingsmodel->get_web_services()->result();
		foreach($web_services as $service) {
			$permissions[$service->name] = FALSE;
		}
		
		//if this user has been linked to the application, we assume they give permissions for send
		//TO-DO: any additional functions that require user approval need to be set here
		//TO-DO: user should have a choice on a per application basis what permissions to allow it and we should look them up here
		$org_id = $this->CI->usersmodel->get_org_id_from_user_id($user_id);
		if($org_id !== FALSE) {
			foreach($web_services as $service) {
				if($this->CI->usersmodel->org_id_linked($org_id, $app_id) === TRUE && 
						$this->CI->usersettingsmodel->is_app_authorized_for_web_service($mailbox_id, $app_id, $service->id)) { 
					$permissions[$service->name] = TRUE; 
				}
			}
		}
		return $permissions;
	}
	
	/* This function looks up the permissions a user has given an app, but uses their Direct address
	 * for the lookup.
	 */
	public function get_user_permissions_for_address($address,$app_id) {
		$this->CI->load->model('usersmodel');
		$this->CI->load->model('groupsmodel');
		$id = $this->CI->usersmodel->get_id_from_direct_address($address);
		if($id !== FALSE) {
			return $this->get_user_permissions_for_app($id,$app_id);
		}
		else {
			$app_dn = $this->CI->applicationmodel->get_dn_from_app_id($app_id);
			return $this->CI->groupsmodel->get_group_address_permissions_for_app_dn($address,$app_id,$app_dn);
		}
		return FALSE;
	}
	
	/*
	 * This function will return true if the passed in array contains the 'admins' key
	 */
	private function search_arr($var) {
		return isset($var[$this->access_level]) && $var[$this->access_level];
	}
	
	/*
	 * Custom array_filter for application permission based on access level
	 */
	private function permission_array_filter($app_list, $callback, $access_level) {
		$this->access_level = $access_level;
		return array_filter($app_list, array($this, "search_arr"));
	}
}
